/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.accounts;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.core.economy.accounts.ImpactorAccount;
import net.impactdev.impactor.core.economy.storage.EconomyStorage;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import org.jetbrains.annotations.Nullable;

public final class AccountManager {
    private final AsyncLoadingCache<AccountKey, Account> accounts = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).buildAsync((key, executor) -> storage.account(key.currency, key.uuid, builder -> builder));

    public AccountManager(EconomyStorage storage) {
    }

    public Optional<Account> accountIfPresent(UUID uuid, Currency currency) {
        return Optional.ofNullable((Account)this.accounts.synchronous().getIfPresent(new AccountKey(uuid, currency)));
    }

    public void update(ImpactorAccount account, @Nullable BigDecimal amount, EconomyTransactionType type) {
        account.setViaNetworking(amount, type);
    }

    public CompletableFuture<Account> account(UUID uuid, Currency currency) {
        return this.accounts.get(new AccountKey(uuid, currency));
    }

    public void invalidate(UUID uuid, Currency currency) {
        this.accounts.synchronous().invalidate(new AccountKey(uuid, currency));
    }

    private record AccountKey(UUID uuid, Currency currency) {
    }
}

